/*
 *      Author:  Peter Harding  <plh@pha.com.au>
 *               Peter Harding & Associates Pty. Ltd.
 *               P.O. Box 6195,
 *               MELBOURNE, VIC, 3004
 *
 *               Phone:   (03)  9820 1261
 *               Fax:     (03)  9578 7810
 *               Mobile:  (018) 375 085
 */

static char
	id[] = "@(#) [3.2.0] rte_disp.c 06/06/96";


//---------------------------------------------------------------------

#ifdef    _STDLIB_
#include <stdlib.h>
#endif /* _STDLIB_ */
#ifdef    _UNISTD_
#include <unistd.h>
#endif /* _UNISTD_ */

#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <errno.h>

#ifdef    SV
#include <string.h>
#else
#include <strings.h>
#endif /* SV */

#include "misc.h"

//---------------------------------------------------------------------

extern int
	errno;

//---------------------------------------------------------------------

void
fprints(
#ifdef    ANSI_PROTO
	FILE  *fp,
	char  *s,
	int   strLen,
	int   lineLen,
	char *termStr,
	int   dottedNull
)
#else
		fp, s, strLen, lineLen, termStr, dottedNull )
	FILE  *fp;
	char  *s;
	int   strLen;
	int   lineLen;
	char *termStr;
	int   dottedNull;
#endif /* ANSI_PROTO */
{
	int
		len;

	char
		ch;

	len = 0;

	while ( strLen-- ) {
			if ( isascii( ch = *s ) ) {
				if ( ch == '^' ) {
					fprintf( fp, "\\^" );
					len += 2;
				} else if ( ch == '\\' ) {
					fprintf( fp, "\\\\" );
					len += 2;
				} else if ( 
					isprint( ch )
						||
					( ch == ' ' )
						||
					( isspace( ch ) && ( fp == stdout ) )
				 ) {
					( void )putc( ch, fp );
					len += 1;
				} else {
            	if ( ( ch == 0 ) && dottedNull ) {
						fprintf( fp, "."  );
						len += 1;
					} else {
						fprintf( fp, "^%c", ( ch | 0x40 ) );
						len += 2;
					}
				}
			} else {
				fprintf( fp, "\\%03o", ch & 0xff );
				len += 4;
			}

		if ( lineLen )
			if ( ( len >= lineLen ) || !strLen ) {
				if ( termStr )
					fprintf( fp, "%s\n", termStr );
				else
					fprintf( fp, "\n" );
				len = 0;
			}

		s++;
	}

	if ( lineLen )
		if ( termStr )
			fprintf( fp, "%s\n", termStr );
		else
			fprintf( fp, "\n" );

	fflush( fp );
}	/* fprints */

//---------------------------------------------------------------------

char*
sprints(
#ifdef    ANSI_PROTO
	char    *b,
	char    *s,
	int      strLen,
	int      padToLen,
	long     quoted
)
#else
		b, s, strLen, padToLen, quoted )
	char    *b;
	char    *s;
	int      strLen;
	int      padToLen;
	long     quoted;
#endif /* ANSI_PROTO */
{
	int
		i,
		quoteAdj;

	char
		*bp,
		ch;

	bp = b;


	if ( padToLen == 0 )
		padToLen = strLen;

	if ( quoted ) {
		*bp++ = '"';
		quoteAdj = 1;
	} else 
		quoteAdj = 0;

	while ( strLen && ( ( ( bp - b ) + quoteAdj ) < padToLen ) ) {
			strLen--;
			if ( isascii( ch = *s ) ) {
				if ( ch == '^' ) {
					sprintf( bp, "\\^" );
					bp += 2;
				} else if ( ch == '\\' ) {
					sprintf( bp, "\\\\" );
					bp += 2;
				} else if ( isprint( ch )
							|| ( ch == ' ' ) ) {
					*bp++ = ch;
				} else {
					sprintf( bp, "^%c", ( ch | 0x40 ) );
					bp += 2;
				}
			} else {
				sprintf( bp, "\\%03o", ch & 0xff );
				bp += 4;
			}
		s++;
	}

	if ( strLen > 0 )
		strcpy( bp - 4, " ..." );

	if ( quoted )
		*bp++ = '"';

	if ( ( bp - b ) < padToLen )
		for ( i = ( bp - b ); i < padToLen; i++ )
			*bp++ = ' ';

	*bp = '\0';
	return b;
}	/* sprints */


//---------------------------------------------------------------------

