/*
 *     Author:    Peter Harding    <plh@pha.com.au>
 *                Peter Harding & Associates Pty. Ltd.
 *                Level 6,
 *                170 Queen Street,
 *                MELBOURNE, VIC, 3000
 *
 *                Phone:    03 9641 2222
 *                Fax:      03 9641 2200
 *                Mobile:   0418 375 085
 *
 *      Copyright (C) Peter Harding, 2002
 *
 *           @(#) [1.0.0] des.h 23/05/2002
 *
 *  $Id:$
 */

#ifndef   _DES_H_
#define   _DES_H_


//----------------------------------------------------------------------------

#define DES_ENCRYPT     1


//----------------------------------------------------------------------------

typedef int
	des_key_schedule;

typedef char
	des_cblock[8];


//----------------------------------------------------------------------------

void des_set_key( des_cblock *key, des_key_schedule ks);
void des_set_odd_parity( des_cblock *key );
void des_ecb_encrypt(des_cblock *magic, des_cblock *lm_hpw, des_key_schedule ks, int flg);

void des_setup( const char *key_56, des_key_schedule ks );
void des_calc( unsigned char *keys, unsigned char *plaintext, unsigned char *results );


//----------------------------------------------------------------------------

#endif /* _DES_H_ */


