/*
 *      Author:   Peter Harding  <plh@performiq.com.au>
 *                PerformIQ Pty. Ltd.
 *                Level 6,
 *                170 Queen Street
 *                MELBOURNE, VIC, 3000
 *
 *                Phone:   (03)  9641 2222
 *                Fax:     (03)  9641 2200
 *                Mobile:  0418 375 085
 *
 *      Copyright (C) Peter Harding, 1997-2007
 *                All rights reserved
 *
 *      $Id:$
 */

static char
    id[] = "@(#) [1.0.0] des.c 23/05/2002";

//------------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <arpa/inet.h>

#include "misc.h"
#include "des.h"

//------------------------------------------------------------------------------

void
des_set_odd_parity(
   des_cblock *key
)
{
}	/* des_set_odd_parity */

//------------------------------------------------------------------------------

void
des_set_key(
   des_cblock       *key,
   des_key_schedule  ks
)
{
}	/* des_set_key */

//------------------------------------------------------------------------------

void
des_ecb_encrypt(
   des_cblock       *magic,
   des_cblock       *lm_hpw,
   des_key_schedule  ks,
   int               flg
)
{
}  /* des_ecb_encrypt */

//------------------------------------------------------------------------------
//  Turns a 56 bit key into the 64 bit, odd parity key and sets the key.
//  The key schedule ks is also set.

void des_setup(
   const char       *key_56,
   des_key_schedule  ks
)
{
	des_cblock
		key;

	key[0] = key_56[0];
	key[1] = ((key_56[0] << 7) & 0xFF) | (key_56[1] >> 1);
	key[2] = ((key_56[1] << 6) & 0xFF) | (key_56[2] >> 2);
	key[3] = ((key_56[2] << 5) & 0xFF) | (key_56[3] >> 3);
	key[4] = ((key_56[3] << 4) & 0xFF) | (key_56[4] >> 4);
	key[5] = ((key_56[4] << 3) & 0xFF) | (key_56[5] >> 5);
	key[6] = ((key_56[5] << 2) & 0xFF) | (key_56[6] >> 6);
	key[7] =  (key_56[6] << 1) & 0xFF;

	des_set_odd_parity( &key );
	des_set_key( &key, ks );
}	/* des_setup */

//------------------------------------------------------------------------------
//  Takes a 21 byte array and treats it as 3 56-bit DES keys. The 8 byte
//  plaintext is encrypted with each key and the resulting 24 bytes are
//  stored in the results array.

void des_calc(
	unsigned char *keys,
	unsigned char *plaintext,
	unsigned char *results
)
{
	des_key_schedule
		ks;

	des_setup( keys,    ks );
	des_ecb_encrypt((des_cblock*) plaintext, (des_cblock*) results,      ks, DES_ENCRYPT);

	des_setup( keys+7,  ks );
	des_ecb_encrypt((des_cblock*) plaintext, (des_cblock*) (results+8),  ks, DES_ENCRYPT);

	des_setup( keys+14, ks );
	des_ecb_encrypt((des_cblock*) plaintext, (des_cblock*) (results+16), ks, DES_ENCRYPT);
}	/* des_calc */

//------------------------------------------------------------------------------

