/*
 *     Author:    Peter Harding    <plh@pha.com.au>
 *                Peter Harding & Associates Pty. Ltd.
 *                Level 6,
 *                170 Queen Street,
 *                MELBOURNE, VIC, 3000
 *
 *                Phone:    03 9641 2222
 *                Fax:      03 9641 2200
 *                Mobile:   0418 375 085
 *
 *      Copyright (C) Peter Harding, 2002
 *
 *  $Id:$
 */

static char
    id[] = "@(#) [1.0.0] cookie.c 05/06/2002";


//----------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <arpa/inet.h>

#include "misc.h"
#include "cookie.h"
#include "trace.h"


//----------------------------------------------------------------------------

static LLCOOKIE
	*llcookie_head   = (LLCOOKIE*)0;


//----------------------------------------------------------------------------

void
freeCookies(
	void
)
{
	LLCOOKIE
		*pCookie = llcookie_head,
		*pNext;

	while ( pCookie ) {
		pNext = pCookie->Next;

		free( pCookie );

		pCookie = pNext;
	}

	llcookie_head = (LLCOOKIE*)0;
}	// freeCookies


//----------------------------------------------------------------------------

void
listCookies(
	void
)
{
	LLCOOKIE
		*pCookie = llcookie_head;

	while ( pCookie ) {
		fprintf( stderr, "[listCookies]  >>>>>>>>>>> %s: \"%s\"\n", pCookie->Name, pCookie->Value );

		pCookie = pCookie->Next;
	}
}	// listCookies


//----------------------------------------------------------------------------

LLCOOKIE*
addCookie(
	LLCOOKIE    *headList,
	const char  *nameStr,
	const char  *valueStr
)
{
	LLCOOKIE
		*pCookie;

	if ( ( pCookie = malloc( sizeof( LLCOOKIE ) ) ) != (LLCOOKIE*)0 ) {
		pCookie->Next = headList;

		strcpy( pCookie->Name,  nameStr );
		strcpy( pCookie->Value, valueStr );
	}

	return pCookie;
}// addCookie


//----------------------------------------------------------------------------

char*
getCookie(
	char *name
)
{
	LLCOOKIE
		*pCookie = llcookie_head;

	while ( pCookie ) {
		if ( !strcmp( name, pCookie->Name ) ) {
			fprintf( stderr, "[getCookie] >>>>> Matched - %s: \"%s\"\n", pCookie->Name, pCookie->Value );
			break;
		}

		pCookie = pCookie->Next;
	}

	if ( pCookie )
		return pCookie->Value;
	else
		return "";
}  // getCookies


//----------------------------------------------------------------------------

LLCOOKIE*
parseCookies(
	char buffer[],
	int  buflen
)
{
	char
   	*pattern = "Set-Cookie:",
		*sp,
		*pName,
		*pValue,
		Name[ 128 ],
		Value[ 128 ];

	int
		cnt = 0,
		len;

	if ( trcFlg & ~TRC_PARSE_COOKIES )
		fprintf( stderr, "                   Parsing Cookies\n" );

	freeCookies();

	sp = buffer;

   while ( sp = strstr( sp, pattern )) {

		pName   = sp + strlen( pattern );

		sp      = strchr( sp, '=' );
	
		if ( sp && sp < ( buffer + buflen )) {
			len  = sp - pName;
	
			if ( len > 127 )
				len = 127;

			strncpy( Name, pName, len );

			Name[ len ] = '\0';

			pValue  = ++sp;

			sp      = strchr( sp, ';' );

			if ( sp && sp < ( buffer + buflen )) {
				len  = sp - pValue - 1;
	
				if ( len > 127 )
					len = 127;

				strncpy( Value, pValue, len );

				Value[ len ] = '\0';
			} else
				break;
		} else
			break;

		if ( trcFlg & TRC_PARSE_COOKIES ) {
			fprintf( tfp, " Name: \"%s\"\n", pName ); 
			fprintf( tfp, "Value: \"%s\"\n", pValue ); 
			fflush( tfp );
		}

		llcookie_head = addCookie( llcookie_head, Name, Value );
	}

	return llcookie_head;
}  // parseCookies


//----------------------------------------------------------------------------

