#!/usr/bin/env python

"""
Basic echo server with time stamp
"""

#---------------------------------------------------------------------

from socket import *                        # import all from socket
from time import time, ctime                # import time.{,c}time()

#---------------------------------------------------------------------

HOST    = ''                                # local host is server
PORT    = 21567                             # port number
BUFSIZ  = 1024                              # default buffer size
ADDR    = (HOST, PORT)                      # network 'address'

#---------------------------------------------------------------------
# create socket, bind it to the given address, and start
# listening, allowing for at most 5 pending connections

tcpSerSock = socket(AF_INET, SOCK_STREAM)
tcpSerSock.bind(ADDR)
tcpSerSock.listen(5)

#----- loop until communication terminates ---------------------------

while 1:
   # wait for client connection
   print 'waiting for connection...'

   # accept client connection
   tcpCliSock, addr = tcpSerSock.accept()
   print '...connected from:', addr

   # loop until communication terminates
   while 1:

      # receive from client
      data = tcpCliSock.recv(BUFSIZ)

      # client quit, so do we
      if not data: break

      # return timestamped data to client
      tcpCliSock.send('[%s] %s' % \
          (ctime(time()), data))

   tcpCliSock.close()   # close client connection

tcpSerSock.close()      # close server connection

#---------------------------------------------------------------------

