#!/usr/bin/env python

from socket import *                        # import all from socket
from time import time, ctime                # import time.{,c}time()

HOST = ''                                # local host is server
PORT = 21567                                # port number
BUFSIZ = 1024                                # default buffer size
ADDR = (HOST, PORT)                        # network 'address'

# create socket, and bind it to the given address
udpSerSock = socket(AF_INET, SOCK_DGRAM)
udpSerSock.bind(ADDR)

# loop until communication terminates
while 1:

    # wait for and receive client message
    print 'waiting for message...'
    data, addr = udpSerSock.recvfrom(BUFSIZ)

    # return timestamped data to client
    udpSerSock.sendto('[%s] %s' % \
        (ctime(time()), data), addr)
    print '...received from and returned to:', addr

udpSerSock.close()                        # close connection
